#!/usr/bin/python
#
#       s i m u l a t o r . p y
#
import sarg, sys, os, time

if sys.version > '3' : raw_input = input  # Python 3

iReg = 0         # instruction register
pReg = 0         # Program counter
regs = [0]*10    # general registers
mem  = [0]*1000  # active memory

codes = ('stop','load','store','load-immediate','load-indirect',
         'add', 'sub', 'mult','div','nop','jump','jump-zero')

mode = sarg.Float("mode",-1)   # neg for confirm

def displayPanel (mesg) :
    global pReg, iReg, regs, mem
    col1 = ['']*15;  col2 = ['']*15
    col1[2] = "             The Mythical Machine"
    col1[3] = "PC: %6d      Inst: %6d" % (pReg, iReg)
    for i in range(5) :
        col1[5+i] = "   Reg %d: %6d     Reg %d: %6d" %  \
                   (         i, regs[i],   i+5, regs[i+5])
    col1[12] = "%s" % mesg

    for i in range(15) :
        if pReg == i+100 : icon = "-->"
        else             : icon = "   "
        col2[i] = "%s %6d  %6d" % (icon,i+100,mem[i+100])

    if mode != 0 :
        os.system("clear")   # For windows use "CLS" (clear screen)
        
    for i in range(15) : print("  %-40s  %s" % (col1[i],col2[i]))    
    if mode < 0 :
        return raw_input("\n\n   Hit enter key to continue:")
    elif mode == 0.0 : return
    else : time.sleep(mode)

def decodeInst() :   # break inst into fields
    global pReg, iReg, regs, mem
    opcode = (iReg // 10000)      # opcode
    reg    = (iReg // 1000) % 10  # regsister
    addr   = (iReg %  1000)       # address
    return (opcode, reg, addr)

def cycle () :
    global pReg, iReg, regs, mem
    running = True
    while running :
        displayPanel("Retrieve Instruction")
        iReg = mem[pReg]
        (opcode,reg,addr) = decodeInst()
        displayPanel("%s   addr=%4d  reg=%2d" % (codes[opcode],addr,reg))
        running = execInst(opcode,reg,addr)
        displayPanel("instruction executed")

def execInst(opcode, r, addr) :
    global pReg, iReg, regs, mem
    if   opcode == 0 : return False               # stop instruction
    elif opcode == 1 : regs[r]=mem[addr]          # load regsister
    elif opcode == 2 : mem[addr]=regs[r]          # store regsister
    elif opcode == 3 : regs[r]=addr               # load regsister immediate
    elif opcode == 4 : regs[r]=mem[regs[addr]]    # load regsister indexed
    elif opcode == 5 : regs[r]=regs[r]+regs[addr] # add regsister
    elif opcode == 6 : regs[r]=regs[r]-regs[addr] # sub regsister
    elif opcode == 7 : regs[r]=regs[r]*regs[addr] # mul regsister
    elif opcode == 8 : regs[r]=regs[r]/regs[addr] # div regsister

    if   opcode < 10  : pReg += 1     # proceed to next inst
    elif opcode ==10  : pReg=addr     # jump unconditionally
    elif opcode ==11  :
        if regs[r]==0 : pReg=addr     # jump if regsister zero
        else          : pReg += 1     # if not proceed
    return True

def loadProgram (file) :
    global pReg, iReg, regs, mem
    fil = open (file,"r")    # file with machine code
    while 1 :
        lin = fil.readline()
        if lin == "" : break
        if lin[0] < '0' : continue   # a comment
        try :
            flds = lin.split()
            address = int(flds[0])
            instruc = int(flds[1])
            mem[address] = instruc
        except : pass
    fil.close()

def main () :
    global pReg, iReg, reg, mem
    loadProgram(sys.argv[1])
    pReg = 100
    while True :
        if not cycle() : break

if __name__ == "__main__" : main()
